#include "q3la.h"

// still missing: per player info!!! kills by weapons!!!
// Netscape compatible???

output::output(resultdata* in_result, outputfile* in_out, configdata* in_config)
{
	config = in_config;
	result = in_result;
	out = in_out;
}

output::output(resultdata_total* in_result_total, outputfile* in_out, configdata* in_config)
{
	config = in_config;
	result_total = in_result_total;
	out = in_out;
	list_players_total_html();
}

output::~output()
{
}

void output::game_info() // extend!!!
{
	html::line (out, "<b>Game info</b>");
	html::table_header(out, "border=\"1\" cellspacing=\"0\" bordercolorlight=\"#000000\" bordercolordark=\"#000000\" bordercolor=\"#000000\"");
	out->write ("<tr>\r\n");
	html::set_td ("<td bgcolor=\"#000080\">");
	html::table_entry_bold (out, "Map");
	html::set_td ("<td bgcolor=\"#808080\">");
	html::table_entry (out, "<p align=\"right\">%s</p>", result->mapname);
	out->write ("</tr>\r\n");
	out->write ("<tr>\r\n");
	html::set_td ("<td bgcolor=\"#000080\">");
	html::table_entry_bold (out, "Timelimit");
	html::set_td ("<td bgcolor=\"#808080\">");
	html::table_entry (out, "<p align=\"right\">%i</p>", result->timelimit);
	out->write ("</tr>\r\n");
	out->write ("<tr>\r\n");
	html::set_td ("<td bgcolor=\"#000080\">");
	html::table_entry_bold (out, "Fraglimit");
	html::set_td ("<td bgcolor=\"#808080\">");
	html::table_entry (out, "<p align=\"right\">%i</p>", result->fraglimit);
	out->write ("</tr>\r\n");
	html::table_footer(out);
}

void output::table_kills_html(int weapon) 
{
	html::set_td ("<td>");
	if (result->get_total_kills(weapon) == 0) {
		return;
	}
	int i;
	int j;
	html::line (out, "<b>Killchart (%s)</b>", weapon_name(weapon));
	html::table_header(out, "border=\"1\" cellspacing=\"0\" bgcolor=\"#808080\" bordercolorlight=\"#000000\" bordercolordark=\"#000000\" bordercolor=\"#000000\"");
	out->write ("<tr>\r\n<td>&nbsp;</td>\r\n<td>&nbsp;</td>\r\n");
	for (i = 0; i < result->get_player_count(); i++) {
		out->write ("<td><p align=\"center\"><font color=\"#FF0000\"><b>%i</b></font></p></td>\r\n", i+1);
	}
	out->write ("<td><b>KILLS</b></td>\r\n");
	out->write ("</tr>\r\n");
	for (i = 0; i < result->get_player_count(); i++) {
		if (result->get_player(i)->name[0] != 0) {
			out->write ("<tr>\r\n<td><b>%s</b></td>\r\n", funname_to_html(result->get_player(i)->name));
		} else {
			out->write ("<tr>\r\n<td>&nbsp;</td>\r\n");
		}
		out->write ("<td width=\"20\"><p align=\"center\"><font color=\"#FF0000\"><b>%i</b></font></p></td>\r\n", i+1);
		for (j = 0; j < result->get_player_count(); j++) {
			if (i != j) {
				out->write ("<td width=\"20\"><p align=\"right\">%i</p></td>\r\n", 
					result->get_kills(i,j,weapon));
			} else {
				out->write ("<td width=\"20\"><p align=\"right\"><font color=\"#0000FF\">%i</font></p></td>\r\n", 
					result->get_kills(i,j,weapon));
			}
		}
		out->write ("<td><p align=\"right\"><b>%i</b></p></td>\r\n", 
			result->get_player_kills(i,weapon));
		out->write ("</tr>\r\n");
	}
	out->write ("<tr>\r\n<td><b>DEATHS</b></td>\r\n");
	out->write ("<td>&nbsp;</td>\r\n");
	for (i = 0; i < result->get_player_count(); i++) {
		out->write ("<td><p align=\"right\"><b>%i</b></p></td>\r\n", 
			result->get_player_killed(i,weapon));
	}
	out->write ("<td><p align=\"right\"><b>%i</b></p></td>\r\n", result->get_total_kills(weapon));
	out->write ("</tr>\r\n");
	html::table_footer(out);
	html::line_header(out); 
	html::line_footer(out);
}

void output::list_players_html()
{
	html::line (out, "<b>Players (sorted by %s)</b>", sortorder_string(config->sortorder_players));
	html::table_header(out, "border=\"1\" cellspacing=\"0\" bordercolorlight=\"#000000\" bordercolordark=\"#000000\" bordercolor=\"#000000\" bgcolor=\"#606060\"");
	out->write ("<tr bgcolor=\"#000080\">\r\n");
	html::set_td ("<td>");
	html::table_entry_bold (out, "Rank");
	html::table_entry_bold (out, "Name");
	html::table_entry_bold (out, "Skill");
	html::table_entry_bold (out, "Frags");
	html::table_entry_bold (out, "FPM");
	html::table_entry_bold (out, "Kills");
	html::table_entry_bold (out, "Killed");
	html::table_entry_bold (out, "Suicides");
	html::table_entry_bold (out, "Deaths");
	html::table_entry_bold (out, "MKIOL");
	html::table_entry_bold (out, "Avg. life");
	html::table_entry_bold (out, "Playtime");
	out->write ("</tr>\r\n");
	for (int i = 0; i < result->get_player_count(); i++) {
		if (i % 2 == 0) {
			out->write ("<tr bgcolor=\"#808080\">\r\n");
		} else {
			out->write ("<tr>\r\n");
		}
		int kills = result->get_player_kills(i);
		int killed = result->get_player_killed(i);
		int suicides = result->get_player_suicides(i);
		int deaths = result->get_player(i)->deaths;
		int frags = kills - deaths - suicides;
		int playtime = result->get_player(i)->playtime;
		html::table_entry (out, "%i", i+1);
		html::table_entry (out, "<b>%s</b>", funname_to_html(result->get_player(i)->name));
		html::table_entry (out, "%.2f", result->get_player(i)->get_skill());
		html::table_entry (out, "%i", frags);
		if (playtime != 0) {
			html::table_entry (out, "%.2f", (double) frags * 60.0 / (double) playtime);
		} else {
			html::table_entry (out, "0.00");
		}
		html::table_entry (out, "%i", kills);
		html::table_entry (out, "%i", killed);
		html::table_entry (out, "%i", suicides);
		html::table_entry (out, "%i", deaths);
		html::table_entry (out, "%i (%s)", result->get_player(i)->mkiol, timestr_m (result->get_player(i)->mkiol_time));
		html::table_entry (out, "%s", timestr_m (playtime / (killed + suicides +  deaths + 1)));
		html::table_entry (out, "%s", timestr_h (playtime));
		out->write ("</tr>\r\n");
	}
	html::table_footer(out);
}

void output::list_players_total_html()
{
	html::html_header(out);
	html::line (out, "<a href=\"games.htm\"><font color=\"#FF0000\" size=\"4\"><b>Game list</b></font></a>");
	html::line (out, "<font size=4><b>Player ranking<br>(sorted by %s)</b></font>", sortorder_string(config->sortorder_players));
	html::table_header(out, "border=\"1\" cellspacing=\"0\" bordercolorlight=\"#000000\" bordercolordark=\"#000000\" bordercolor=\"#000000\" bgcolor=\"#606060\"");
	out->write ("<tr bgcolor=\"#000080\">\r\n");
	html::set_td ("<td>");
	html::table_entry_bold (out, "Rank");
	html::table_entry_bold (out, "Name");
	html::table_entry_bold (out, "Skill");
	html::table_entry_bold (out, "Frags");
	html::table_entry_bold (out, "Kills");
	html::table_entry_bold (out, "Killed");
	html::table_entry_bold (out, "Suicides");
	html::table_entry_bold (out, "Deaths");
	html::table_entry_bold (out, "Playtime");
	out->write ("</tr>\r\n");
	int rank = 1;
	player_t* temp_player = result_total->get_player_first()->next;
	while (temp_player != 0) {
		if (rank % 2 == 0) {
			out->write ("<tr bgcolor=\"#808080\">\r\n");
		} else {
			out->write ("<tr>\r\n");
		}
		html::table_entry (out, "%i", rank);
		html::table_entry (out, "<b>%s</b>", funname_to_html(temp_player->name));
		html::table_entry (out, "%.2f", temp_player->get_skill());
		html::table_entry (out, "%i", temp_player->get_kills() - temp_player->deaths - temp_player->get_suicides());
		html::table_entry (out, "%i", temp_player->get_kills());
		html::table_entry (out, "%i", temp_player->get_killed());
		html::table_entry (out, "%i", temp_player->get_suicides());
		html::table_entry (out, "%i", temp_player->deaths);
		html::table_entry (out, "%s", timestr_h (temp_player->playtime));
		out->write ("</tr>\r\n");
		temp_player = temp_player->next;
		rank++;
	}
	html::table_footer(out);
	html::html_footer(out);
}

char* output::weapon_name(int weapon) // crap
{
	static char name[64];
	name[0] = 0;
	switch (weapon) {
	case 0:
		strcpy (name, "All weapons");
		break;
	case 1:
		strcpy (name, "Shotgun");
		break;
	case 2:
		strcpy (name, "Gauntlet");
		break;
	case 3:
		strcpy (name, "Machinegun");
		break;
	case 4:
		strcpy (name, "Grenade");
		break;
	case 5:
		strcpy (name, "Grenade splash");
		break;
	case 6:
		strcpy (name, "Rocket");
		break;
	case 7:
		strcpy (name, "Rocket splash");
		break;
	case 8:
		strcpy (name, "Plasma");
		break;
	case 9:
		strcpy (name, "Plasma splash");
		break;
	case 10:
		strcpy (name, "Railgun");
		break;
	case 11:
		strcpy (name, "Lightning gun");
		break;
	case 12:
		strcpy (name, "BFG");
		break;
	case 13:
		strcpy (name, "BFG splash");
		break;
	case 18:
		strcpy (name, "Telefrag");
		break;
	case 20:
		strcpy (name, "Suicide");
		break;
	default:
		sprintf (name, "weapon %i", weapon);
		break;
	}
	return name;
}

void output::game_data(int gamecount)
{
	outputfile gamedata;
	gamedata.open_append ("..\\q3ladata.txt");
	for (int i = 0; i < result->get_player_count(); i++) {
		gamedata.write ("%i", gamecount);
		gamedata.write (",%s", funname_to_ascii (result->get_player(i)->name));
		gamedata.write (",%i", result->get_player_kills(i));
		gamedata.write (",%i", result->get_player_killed(i));
		gamedata.write (",%i", result->get_player_suicides(i));
		gamedata.write (",%i", result->get_player(i)->deaths);
		gamedata.write (",%s", timestr_h (result->get_player(i)->playtime));

		// kills
		gamedata.write (",%i", result->get_player_kills(i,1)); // Shotgun
		gamedata.write (",%i", result->get_player_kills(i,2)); // Gauntlet
		gamedata.write (",%i", result->get_player_kills(i,3)); // Machinegun
		gamedata.write (",%i", result->get_player_kills(i,4)); // Grenade Launcher
		gamedata.write (",%i", result->get_player_kills(i,6)); // Rocket Launcher
		gamedata.write (",%i", result->get_player_kills(i,8)); // Plasma
		gamedata.write (",%i", result->get_player_kills(i,10)); // Railgun
		gamedata.write (",%i", result->get_player_kills(i,11)); // Lightning Gun
		gamedata.write (",%i", result->get_player_kills(i,12)); // BFG
		gamedata.write (",%i", result->get_player_kills(i,18)); // Telefrag
		gamedata.write (",%i", result->get_player_kills(i,20)); // Suicide ("/kill" in console)

		// killed
		gamedata.write (",%i", result->get_player_killed(i,1)); // Shotgun
		gamedata.write (",%i", result->get_player_killed(i,2)); // Gauntlet
		gamedata.write (",%i", result->get_player_killed(i,3)); // Machinegun
		gamedata.write (",%i", result->get_player_killed(i,4)); // Grenade Launcher
		gamedata.write (",%i", result->get_player_killed(i,6)); // Rocket Launcher
		gamedata.write (",%i", result->get_player_killed(i,8)); // Plasma
		gamedata.write (",%i", result->get_player_killed(i,10)); // Railgun
		gamedata.write (",%i", result->get_player_killed(i,11)); // Lightning Gun
		gamedata.write (",%i", result->get_player_killed(i,12)); // BFG
		gamedata.write (",%i", result->get_player_killed(i,18)); // Telefrag
		gamedata.write (",%i", result->get_player_killed(i,20)); // Suicide ("/kill" in console)

		gamedata.write ("\r\n");
	}
	gamedata.close();
}

char* output::timestr_h(int sec)
{
	static char str[16];
	str[0] = 0;
	sprintf (str, "%i:%02i:%02i h", time_h(sec), time_m(sec), time_s(sec));
	return str;
}

char* output::timestr_m(int sec)
{
	static char str[16];
	str[0] = 0;
	sprintf (str, "%i:%02i min", time_h(sec)*60 + time_m(sec), time_s(sec));
	return str;
}

int output::time_h(int seconds)
{
	return (seconds/3600);
}

int output::time_m(int seconds)
{
	return ((seconds%3600)/60);
}

int output::time_s(int seconds)
{
	return ((seconds%3600)%60);
}

char* output::funname_to_html(char *name) // check for completeness!!!
{
	char color_str[7][8] = { "", "black", "red", "green", "yellow", "blue", "cyan" };
	static char new_name[512];
	new_name[0] = 0;
	for (unsigned int i = 0; i < strlen (name); i++) {
		if (name[i] == '^') {
			if ((name[i+1] > '0') && (name[i+1] < '7')) {
				char tempstr[2];
				tempstr[0] = name[++i];
				tempstr[1] = 0;
				strcat (new_name, "<font color=\"");
				strcat (new_name, color_str[atoi(tempstr)]);
				strcat (new_name, "\">");
				strncat (new_name, name+(++i), 1);
				strcat (new_name, "</font>");
			} else {
				i++;
				strncat (new_name, name+(++i), 1);
			}
		} else {
			strncat (new_name, name+i, 1);
		}
	}
	return new_name;
}

char* output::funname_to_ascii(char *name) // check for completeness!!!
{
	static char new_name[64];
	new_name[0] = 0;
	for (unsigned int i = 0; i < strlen (name); i++) {
		if (name[i] == '^') {
			if ((name[i+1] >= '0') && (name[i+1] <= '9')) {
				i++;
				strncat (new_name, name+(++i), 1);
			}
		} else {
			strncat (new_name, name+i, 1);
		}
	}
	return new_name;
}

char* output::sortorder_string (sort_t order) // crap
{
	static char str[16];
	switch (order) {
	case so_frags:
		strcpy (str, "frags");
		break;
	case so_kills:
		strcpy (str, "kills");
		break;
	case so_name:
		strcpy (str, "name");
		break;
	case so_skill:
		strcpy (str, "skill");
		break;
	default:
		strcpy (str, "?");
		break;
	}
	return str;
}